# Admin Panel (MVP)

## 1) Upload
Copy the `admin/` folder to your webroot (e.g., `/var/www/html/admin`).

## 2) Configure DB
EITHER set PHP-FPM env vars (recommended):
  DB_HOST=...
  DB_PORT=25060
  DB_USER=api_rfid
  DB_PASS=********
  DB_NAME=tickets01

OR create `/admin/.env` with:
  DB_HOST=db-mysql-nyc3-07573-ticket-01-do-user-1404294-0.h.db.ondigitalocean.com
  DB_PORT=25060
  DB_USER=api_rfid
  DB_PASS=YourStrongPasswordHere
  DB_NAME=tickets01

Ensure the MySQL CA exists at `/etc/ssl/do/do_mysql_ca.pem` on the server.

## 3) Create admin tables
Run in MySQL:
  CREATE TABLE IF NOT EXISTS admin_users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    email VARCHAR(255) NOT NULL UNIQUE,
    name  VARCHAR(100) NOT NULL,
    role  ENUM('admin','manager','boxoffice','security','viewer') NOT NULL DEFAULT 'viewer',
    password_hash VARCHAR(255) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

  CREATE TABLE IF NOT EXISTS admin_sessions (
    id CHAR(36) PRIMARY KEY,
    user_id INT NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    last_seen  TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES admin_users(id) ON DELETE CASCADE
  );

## 4) Seed your first admin
  # generate a hash (one-time) in PHP:
  <?php echo password_hash('ChangeThisStrongPassword!', PASSWORD_ARGON2ID), PHP_EOL; ?>

  INSERT INTO admin_users (email,name,role,password_hash)
  VALUES ('you@example.com','You','admin','<paste_hash_here>');

## 5) Visit
  https://your-domain/admin/login.php

## Notes
- Uses MySQL over TLS with your DO CA path `/etc/ssl/do/do_mysql_ca.pem`.
- Add ticket editing endpoints later (`api/ticket_update.php`) with CSRF + role checks.
- Protect `/admin/` with HTTPS and consider IP allowlists if desired.
