<?php
require_once __DIR__.'/_bootstrap.php';

function current_user(): ?array {
  if (empty($_SESSION['uid'])) return null;
  return $_SESSION['user'] ?? null;
}
function require_login(array $roles = []): void {
  $u = current_user();
  if (!$u) { header('Location: /admin/login.php'); exit; }
  if ($roles && !in_array($u['role'], $roles, true)) { http_response_code(403); exit('Forbidden'); }
}

function login_user(array $user): void {
  $_SESSION['uid']  = $user['id'];
  $_SESSION['user'] = $user;
}
function logout_user(): void {
  session_destroy();
}
?>