<?php
if (defined('ADMIN_BOOTSTRAP_LOADED')) { return; }
define('ADMIN_BOOTSTRAP_LOADED', 1);

declare(strict_types=1);
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
ini_set('display_errors','0'); error_reporting(E_ALL);

// Sessions
session_set_cookie_params([
  'lifetime'=>0, 'path'=>'/', 'domain'=>'', 'secure'=>true,
  'httponly'=>true, 'samesite'=>'Strict'
]);
if (session_status() !== PHP_SESSION_ACTIVE) { session_start(); }

// Optional .env loader (key=value per line). Values are added to $_ENV/getenv.
$dotEnv = __DIR__ . '/.env';
if (is_readable($dotEnv)) {
  $ini = parse_ini_file($dotEnv, false, INI_SCANNER_RAW);
  if (is_array($ini)) {
    foreach ($ini as $k=>$v) { $_ENV[$k] = $v; putenv($k.'='.$v); }
  }
}

// --- DB config (prefer env; fallback to empty to force setup) ---
$dbHost = $_ENV['DB_HOST'] ?? getenv('DB_HOST') ?: '';
$dbPort = (int)($_ENV['DB_PORT'] ?? getenv('DB_PORT') ?: 0);
$dbUser = $_ENV['DB_USER'] ?? getenv('DB_USER') ?: '';
$dbPass = $_ENV['DB_PASS'] ?? getenv('DB_PASS') ?: '';
$dbName = $_ENV['DB_NAME'] ?? getenv('DB_NAME') ?: '';

// DigitalOcean Managed MySQL CA path (per your standard)
$caPath = '/etc/ssl/do/do_mysql_ca.pem';

function assert_config(): void {
  global $dbHost,$dbPort,$dbUser,$dbPass,$dbName;
  if ($dbHost === '' || $dbPort === 0 || $dbUser === '' || $dbName === '') {
    http_response_code(500);
    echo "<h1>Admin setup required</h1><p>Missing DB configuration. Create <code>/admin/.env</code> or set PHP-FPM env vars.</p>";
    echo "<pre>DB_HOST=...\nDB_PORT=25060\nDB_USER=api_rfid\nDB_PASS=********\nDB_NAME=tickets01</pre>";
    exit;
  }
}

function db(): mysqli {
  static $m; global $dbHost,$dbPort,$dbUser,$dbPass,$dbName,$caPath;
  if ($m) return $m;
  assert_config();
  $m = mysqli_init();
  if (defined('MYSQLI_OPT_SSL_MODE') && defined('MYSQLI_SSL_MODE_VERIFY_IDENTITY')) {
    mysqli_options($m, MYSQLI_OPT_SSL_MODE, MYSQLI_SSL_MODE_VERIFY_IDENTITY);
  } elseif (defined('MYSQLI_OPT_SSL_VERIFY_SERVER_CERT')) {
    mysqli_options($m, MYSQLI_OPT_SSL_VERIFY_SERVER_CERT, true);
  }
  if (!is_readable($caPath)) {
    http_response_code(500);
    echo "MySQL CA not readable at {$caPath}"; exit;
  }
  mysqli_ssl_set($m, null, null, $caPath, null, null);
  mysqli_real_connect($m, $dbHost, $dbUser, $dbPass, $dbName, $dbPort ?: 3306, null, MYSQLI_CLIENT_SSL);
  $m->set_charset('utf8mb4');
  return $m;
}

function json_out($a, int $code=200): never { http_response_code($code); header('Content-Type: application/json'); echo json_encode($a, JSON_UNESCAPED_SLASHES); exit; }

function csrf_token(): string {
  if (empty($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
  return $_SESSION['csrf'];
}
function csrf_require(): void {
  if (($_POST['csrf'] ?? '') !== ($_SESSION['csrf'] ?? '')) { http_response_code(419); exit('CSRF'); }
}
?>