<?php
require_once __DIR__.'/_auth.php'; require_login(['admin','manager','boxoffice','security','viewer']);
$m = db();
$cards = [
  'tickets_total' => $m->query("SELECT COUNT(*) c FROM tickets")->fetch_assoc()['c'] ?? 0,
  'entered_today' => $m->query("SELECT COUNT(*) c FROM tickets WHERE DATE(ticketLastUpdated)=CURDATE() AND ticketStatus='entered'")->fetch_assoc()['c'] ?? 0,
  'denials_today' => $m->query("SELECT COUNT(*) c FROM scanLog WHERE DATE(scanTimestamp)=CURDATE() AND scanResult LIKE 'deny%'")->fetch_assoc()['c'] ?? 0,
];
$me = $_SESSION['user'];
?>
<!doctype html><html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Admin Dashboard</title>
<link rel="stylesheet" href="/admin/assets/admin.css">
</head><body>
<header class="topbar">
  <div class="brand">🎟️ Admin</div>
  <nav>
    <a href="/admin/index.php">Dashboard</a>
    <a href="/admin/tickets.php">Tickets</a>
    <a href="/admin/scans.php">Scan Log</a>
  </nav>
  <div class="user">Signed in as <b><?=htmlspecialchars($me['name'])?></b> (<?=htmlspecialchars($me['role'])?>) — <a href="/admin/logout.php">Logout</a></div>
</header>
<main class="content">
  <h1>Dashboard</h1>
  <section class="cards">
    <div class="card"><div class="muted">Total Tickets</div><div class="big"><?=$cards['tickets_total']?></div></div>
    <div class="card"><div class="muted">Entered Today</div><div class="big"><?=$cards['entered_today']?></div></div>
    <div class="card"><div class="muted">Denials Today</div><div class="big"><?=$cards['denials_today']?></div></div>
  </section>
</main>
</body></html>
