<?php
require_once __DIR__.'/_bootstrap.php';

// If already logged in, bounce to dashboard
if (!empty($_SESSION['uid'])) { header('Location: /admin/index.php'); exit; }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_require();
  $email = strtolower(trim((string)($_POST['email'] ?? '')));
  $pass  = (string)($_POST['password'] ?? '');
  if ($email && $pass) {
    $stmt = db()->prepare("SELECT id,email,name,role,password_hash FROM admin_users WHERE email=?");
    $stmt->bind_param('s',$email); $stmt->execute();
    $res = $stmt->get_result(); $user = $res->fetch_assoc(); $stmt->close();
    if ($user && password_verify($pass, $user['password_hash'])) {
require_once __DIR__.'/_auth.php'; login_user($user);
      header('Location: /admin/index.php'); exit;
    }
    $err = 'Invalid credentials';
  } else {
    $err = 'Email and password are required';
  }
}
?>
<!doctype html><html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Admin Login</title>
<link rel="stylesheet" href="/admin/assets/admin.css">
</head><body class="login">
<main class="card">
  <h1>Admin Login</h1>
  <?php if (!empty($err)): ?><p class="err"><?=htmlspecialchars($err)?></p><?php endif; ?>
  <form method="post">
    <input type="hidden" name="csrf" value="<?=htmlspecialchars(csrf_token())?>">
    <label>Email<br><input name="email" type="email" required autofocus></label>
    <label>Password<br><input name="password" type="password" required></label>
    <button type="submit">Sign in</button>
  </form>
</main>
</body></html>
