<?php require __DIR__.'/_auth.php'; require_login(['admin','manager','security','viewer']); ?>
<!doctype html><html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Scan Log</title>
<link rel="stylesheet" href="/admin/assets/admin.css">
</head><body>
<header class="topbar">
  <div class="brand">🎟️ Admin</div>
  <nav>
    <a href="/admin/index.php">Dashboard</a>
    <a href="/admin/tickets.php">Tickets</a>
    <a href="/admin/scans.php" class="active">Scan Log</a>
  </nav>
  <div class="user"><a href="/admin/logout.php">Logout</a></div>
</header>
<main class="content">
  <h1>Scan Log</h1>
  <form id="s" class="search"><input name="q" placeholder="bandID / device / result"><button>Search</button></form>
  <table id="t" class="table"><thead><tr><th>When</th><th>bandID</th><th>Device</th><th>Location</th><th>Result</th></tr></thead><tbody></tbody></table>
</main>
<script>
const form=document.getElementById('s'), tbody=document.querySelector('#t tbody');
async function load(q=''){ const r=await fetch('/admin/api/scans_list.php?q='+encodeURIComponent(q)); const j=await r.json();
  tbody.innerHTML=''; j.rows.forEach(r=>{ const tr=document.createElement('tr');
    tr.innerHTML=`<td>${r.scanTimestamp||''}</td><td>${r.scanTagID||''}</td><td>${r.scanDevice||''}</td><td>${r.scanLocation||''}</td><td>${r.scanResult||''}</td>`;
    tbody.appendChild(tr);
  });
}
form.addEventListener('submit',e=>{e.preventDefault(); load(new FormData(form).get('q')||'');});
load();
</script>
</body></html>
